/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.search;

import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.search.VWBaseSearchOptions;
import filenet.vw.toolkit.admin.search.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.query.VWScopeChangeEvent;
import javax.swing.JOptionPane;

class VWWorkflowObjectSearchOptions
extends VWBaseSearchOptions {
    public VWWorkflowObjectSearchOptions() {
        this.m_name = VWResource.s_workflowObjects;
    }

    public VWScopeChangeEvent createScopeChangeEvent(Object source, VWSession session) {
        VWScopeChangeEvent scEvent = null;
        if (VWStringUtils.compare(this.m_selectedScope, this.m_workflowRosterItem) == 0) {
            scEvent = this.createRosterScopeChangeEvent(source, session);
        } else if (VWStringUtils.compare(this.m_selectedScope, this.m_userQueueItem) == 0 || VWStringUtils.compare(this.m_selectedScope, this.m_workQueueItem) == 0 || VWStringUtils.compare(this.m_selectedScope, this.m_componentQueueItem) == 0 || VWStringUtils.compare(this.m_selectedScope, this.m_systemQueueItem) == 0) {
            scEvent = this.createQueueScopeChangeEvent(source, session);
        }
        return scEvent;
    }

    public int getResultType() {
        return 2;
    }

    public void setScope(String nItemName) {
        super.setScope(nItemName);
        this.m_nVisibleTabs = 14;
        if (VWStringUtils.compare(nItemName, this.m_userQueueItem) == 0) {
            this.m_nVisibleTabs |= 1;
        }
    }

    public String[] getScopeOptions() {
        String[] items = null;
        try {
            items = new String[]{this.m_workflowRosterItem, this.m_userQueueItem, this.m_workQueueItem, this.m_componentQueueItem, this.m_systemQueueItem};
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }

    public String[] getSpecificScopeOptions() {
        if (VWStringUtils.compare(this.m_selectedScope, this.m_workflowRosterItem) == 0) {
            return this.m_rosterNames;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_userQueueItem) == 0) {
            return this.m_userQueueNames;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_workQueueItem) == 0) {
            return this.m_workQueueNames;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_componentQueueItem) == 0) {
            return this.m_componentQueueNames;
        }
        if (VWStringUtils.compare(this.m_selectedScope, this.m_systemQueueItem) == 0) {
            return this.m_systemQueueNames;
        }
        return null;
    }

    protected VWScopeChangeEvent createQueueScopeChangeEvent(Object source, VWSession session) {
        VWQueue vwQueue = null;
        VWQueueDefinition vwQueueDef = null;
        VWScopeChangeEvent scEvent = null;
        try {
            if (this.m_selectedSpecificScope == null) {
                return null;
            }
            if (session != null) {
                try {
                    vwQueue = session.getQueue(this.m_selectedSpecificScope);
                    vwQueueDef = vwQueue.fetchQueueDefinition();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    JOptionPane.showMessageDialog(null, ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
                }
            }
            scEvent = new VWScopeChangeEvent(source);
            scEvent.setType(2);
            scEvent.setDefinitionObject(vwQueueDef);
            scEvent.setDefaultColumns(this.getDefaultColumns(vwQueueDef));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return scEvent;
    }
}

